//
//  Shaders.metal
//  ComputeShader
//
//  Created by Alex Hoppen on 26.07.19.
//  Copyright © 2019 Alex Hoppen. All rights reserved.
//

#include <metal_stdlib>
using namespace metal;

kernel void redTintBuffer(device const uint32_t *inBuffer [[buffer(0)]],
                          device uint32_t *outBuffer [[buffer(1)]],
                          uint gid [[thread_position_in_grid]]) {
    uint32_t color = inBuffer[gid];
    
    uint16_t red = color & 0xff;
    red *= 2;
    if (red > 255) {
        red = 255;
    }
    color = (color & (~0xff)) | red;
    
    outBuffer[gid] = color;
}
